$("#tutorial").on("click", function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: "Sair",
            closeBtnText: "Fechar",
            nextBtnText: "Próximo",
            prevBtnText: "Anterior",
            allowClose: false,
        });
        driver.defineSteps([
            {
                element: "#campostudo",
                popover: {
                    title: "Dados Gerais",
                    description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
                    position: "top",
                },
            },
            {
                element: "#tutorialTipo",
                popover: {
                    title: "Tipo",
                    description:
                        "Aqui informação qual o tipo da região do estado.",
                    position: "top",
                },
            },
            {
                element: "#tutorialRegiaoCota",
                popover: {
                    title: "Tipo",
                    description:
                        "Aqui informação se é uma região de cota.",
                    position: "top",
                },
            },
            {
                element: "#tutorialCodigo",
                popover: {
                    title: "Código",
                    description:
                        "Neste campo informamos o código da Região do Estado, pode informar ou ser gerado automaticamente.",
                    position: "right",
                },
            },
            {
                element: "#tutorialCodigo2",
                popover: {
                    title: "Código 2",
                    description:
                        "Aqui informamos o código secundário da região do estado caso necessário.",
                    position: "top",
                },
            },
            {
                element: "#tutorialDescricao",
                popover: {
                    title: "Descrição",
                    description:
                        "Em seguida, informamos a descrição do código da região do estado.",
                    position: "left",
                },
            },
            {
                element: "#tutorialObs",
                popover: {
                    title: "Observação",
                    description:
                        "Neste último campo informamos a observação da região do estado.",
                    position: "bottom",
                },
            },
            {
                element: "#btnVoltar",
                popover: {
                    title: "Botão Voltar",
                    description:
                        "Ao clicar nesse botão você retorna para a tela de acesso.",
                    position: "left",
                },
            },
            {
                element: "#btnGravar",
                popover: {
                    title: "Botão Gravar",
                    description: "Clique aqui para gravar a região do estado.",
                    position: "left",
                },
            },
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    const queryString = window.location.href;
    const parametros = queryString.split("/");
    const cadregestado = parametros[parametros.length - 1];


    if (cadregestado != '' && cadregestado != 'create') {
        await consultaRegEstado(cadregestado);
    };

    async function consultaRegEstado(codigoRegEstado) {
        $.LoadingOverlay('show');
        try {
            const pesquisaRegEstado = {
                tabela: 'REG_ESTADO',
                camposSelect: ['CODIGO', 'CODIGO2', 'TIPO', 'COTA', 'DESCRICAO', 'OBS'],
                where: [`CODIGO = '${codigoRegEstado}'`]
            };

            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaRegEstado));

            $('#txtCodigo').val(jsonStr[0].CODIGO);
            $('#txtCodigo').prop('disabled', true);
            $('#txtCodigo2').val(jsonStr[0].CODIGO2);
            $('#txtDescricao').val(jsonStr[0].DESCRICAO);
            $('#txtObs').val(jsonStr[0].OBS);

            if (jsonStr[0].COTA == 'S') {
                $('#cbRegiaoCota').prop('checked', true);
            };

            if (jsonStr[0].TIPO == '0') {
                $('#radioComercial').prop('checked', true);
                $('#radioLogistica').prop('checked', false);
            } else {
                $('#radioLogistica').prop('checked', true);
                $('#radioComercial').prop('checked', false);
            };
        } catch {
            console.error(error);
            msgErro('Não foi possível buscar os dados da região do estado! Por favor, verifique e tente novamente.');
            return;
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $("#btnVoltar").on("click", async function () {
        await deletaRegistro("CADREGESTADO", getCookie("usuario"), cadregestado);
        window.location.href = `${BASE_URI}/cadregestado`;
    });

    //   if (cstipi != "" && cstipi != "create") {
    //     if ((await liberarRegistro("CSTIPI", cstipi)) == false) {
    //       window.location.href = "../cstipi";
    //     } else {
    //       carregaDados(cstipi);
    //     }
    //   }


    $("#btnGravar").click(async function () {
        try {
            $.LoadingOverlay("show");

            if ($('#txtCodigo').val() == '') {
                msgErro('O código não pode estar vazio, por favor verifique e tente novamente!');
                $.LoadingOverlay("hide");
                return;
            };

            if ($('#txtDescricao').val() == '') {
                msgErro('A descrição não pode estar vazia, por favor verifique e tente novamente!');
                $.LoadingOverlay("hide");
                return;
            };

            const objeto = {};

            objeto.CODIGO = $("#txtCodigo").val();
            objeto.DESCRICAO = $("#txtDescricao").val();
            objeto.CODIGO2 = $('#txtCodigo2').val();
            objeto.OBS = $('#txtObs').val();
            objeto.TIPO = $('#radioComercial').is(':checked') ? '0' : '1';
            objeto.COTA = $('#cbRegiaoCota').is(':checked') ? 'S' : 'N';

            const response = await requisicao(
                "POST",
                "/Sisplan/Cadastros/v1/cadregestado?",
                `JSON=${encodeURIComponent(JSON.stringify(objeto))}`,
                null
            );

            if (!response) {
                msgErro('Não foi possível gravar o cadastro da região do estado, por favor verifique e tente novamente!');
                $.LoadingOverlay("hide");
                return;
            };

            if (response.status != 200) {
                const jsonStr = await response.json();
                $.LoadingOverlay("hide");
                msgErro(jsonStr.mensagem);
                return;
            };

            $.LoadingOverlay("hide");
            toastr
                .success("Cadastro efetuado com sucesso!", "Confirmação", {
                    toastClass: "alert",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/cadregestado`;
                    },
                })
                .css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgErro(`Não foi possível gravar os dados da região do estado. Erro: ${error}`);
        };
    });
});
